#ifndef __FLASH_H__
#define __FLASH_H__

#include <unistd.h>

extern ssize_t flash_write(const void *buf, size_t count);

extern ssize_t flash_read(void *buf, size_t count);

extern off_t flash_lseek(off_t offset, int whence);

extern void flash_open(void);

#ifndef __TIMESTAMP__
#define __TIMESTAMP__
#endif

#ifndef __VERSION__
#define __VERSION__
#endif

#define CN0359_VERSION "<" __TIME__ ">, <" __DATE__ ">, <" __VERSION__ ">, <" __TIMESTAMP__ ">, " "<Circuits from the Lab>, " "<Copyright 2016, Analog Devices, Inc. All rights reserved.> "

struct flash_file
{
	int baud_rate = 115200;
	int rs485_address = 30;
	float voltage = 1.f;
	float frequency = 100.f;
	float temp_coef = 2.f;
	float cell_const = 1.f;
	float setup = 10.f;
	float hold = 1.f;
	int lcd_uc1601s_br = 3;
	int lcd_uc1601s_pm = 104;
	int lcd_uc1601s_tc = 2;
}const default_setting;

struct
{
	const int min_baud_rate = 9600;
	const int max_baud_rate = 460800;

	const int min_rs485_address = 1;
	const int max_rs485_address = 254;

	const float min_voltage = 0.1f;
	const float max_voltage = 10.f;

	const float min_freq = 10.f;
	const float max_freq = 100.e3f;

	const float min_temp_coef = -10.f;
	const float max_temp_coef = 10.f;

	const float min_cell_const = 0.01f;
	const float max_cell_const = 100.f;

	const float min_setup = 0.f;
	const float max_setup = 80.f;

	const float min_hold = 0.f;
	const float max_hold = 10.f;

	const int min_lcd_uc1601s_br = 0;
	const int max_lcd_uc1601s_br = 3;

	const int min_lcd_uc1601s_pm = 0;
	const int max_lcd_uc1601s_pm = 255;

	const int min_lcd_uc1601s_tc = 0;
	const int max_lcd_uc1601s_tc = 3;

	const char version[sizeof(CN0359_VERSION)] = CN0359_VERSION;
}const configure_file;

const char zeros[512] = {};

#endif
